/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.dialogs;

import com.intel.sgx.dialogs.SGXDialogBase;
import com.intel.sgx.handlers.EnclaveConfigHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnclaveConfigDialog
extends SGXDialogBase {
    private Shell shell;
    private EnclaveConfigHandler enclaveConfig;
    private Label statusLabel;
    private Text prodID;
    private Text isvSvn;
    private Text stackMinSize;
    private Text stackMaxSize;
    private Text heapMinSize;
    private Text heapInitSize;
    private Text heapMaxSize;
    private Text tcsNum;
    private Text tcsMaxNum;
    private Text tcsPool;
    private Combo tcsPolicy;
    private Button disableDebug;

    public EnclaveConfigDialog(Shell shell, EnclaveConfigHandler enclaveConfigHandler) {
        super(shell);
        this.shell = shell;
        this.enclaveConfig = enclaveConfigHandler;
        this.setShellStyle(48);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 65);
        label.setText("Note: Use this Menu to change the Enclave settings.");
        this.statusLabel = new Label(composite2, 65);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)gridData2);
        this.statusLabel.setText("");
        this.statusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout(3, false));
        group2.setText("Modify the Enclave Settings here...");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        group2.setLayoutData((Object)gridData3);
        Label label2 = new Label((Composite)group2, 0);
        label2.setText("Product ID:");
        label2.setLayoutData((Object)new GridData(1));
        this.prodID = new Text((Composite)group2, 2052);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        gridData4.widthHint = 400;
        this.prodID.setLayoutData((Object)gridData4);
        this.prodID.setText(this.enclaveConfig.prodId);
        this.prodID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.prodId = EnclaveConfigDialog.this.prodID.getText();
            }
        });
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("ISV SVN:");
        label3.setLayoutData((Object)new GridData(1));
        this.isvSvn = new Text((Composite)group2, 2052);
        this.isvSvn.setLayoutData((Object)gridData4);
        this.isvSvn.setText(this.enclaveConfig.isvSvn);
        this.isvSvn.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.isvSvn = EnclaveConfigDialog.this.isvSvn.getText();
            }
        });
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Minimum Stack Size:");
        label4.setLayoutData((Object)new GridData(1));
        this.stackMinSize = new Text((Composite)group2, 2052);
        this.stackMinSize.setLayoutData((Object)gridData4);
        this.stackMinSize.setText(this.enclaveConfig.stackMinSize);
        this.stackMinSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.stackMinSize = EnclaveConfigDialog.this.stackMinSize.getText();
                if (!EnclaveConfigDialog.this.stackMinSize.getText().matches("0x[0-9a-fA-F]{1,}000")) {
                    EnclaveConfigDialog.this.statusLabel.setText("Error: The Minimum Stack Size value must be Page Aligned.");
                } else {
                    EnclaveConfigDialog.this.checkPageAlign(EnclaveConfigDialog.this.stackMinSize);
                }
            }
        });
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Maximum Stack Size:");
        label5.setLayoutData((Object)new GridData(1));
        this.stackMaxSize = new Text((Composite)group2, 2052);
        this.stackMaxSize.setLayoutData((Object)gridData4);
        this.stackMaxSize.setText(this.enclaveConfig.stackMaxSize);
        this.stackMaxSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.stackMaxSize = EnclaveConfigDialog.this.stackMaxSize.getText();
                if (!EnclaveConfigDialog.this.stackMaxSize.getText().matches("0x[0-9a-fA-F]{1,}000")) {
                    EnclaveConfigDialog.this.statusLabel.setText("Error: The Maximum Stack Size value must be Page Aligned.");
                } else {
                    EnclaveConfigDialog.this.checkPageAlign(EnclaveConfigDialog.this.stackMaxSize);
                }
            }
        });
        Label label6 = new Label((Composite)group2, 0);
        label6.setText("Minimum Heap Size:");
        label6.setLayoutData((Object)new GridData(1));
        this.heapMinSize = new Text((Composite)group2, 2052);
        this.heapMinSize.setLayoutData((Object)gridData4);
        this.heapMinSize.setText(this.enclaveConfig.heapMinSize);
        this.heapMinSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.heapMinSize = EnclaveConfigDialog.this.heapMinSize.getText();
                if (!EnclaveConfigDialog.this.heapMinSize.getText().matches("0x[0-9a-fA-F]{1,}000")) {
                    EnclaveConfigDialog.this.statusLabel.setText("Error: The Minimum Heap Size value must be Page Aligned.");
                } else {
                    EnclaveConfigDialog.this.checkPageAlign(EnclaveConfigDialog.this.heapMinSize);
                }
            }
        });
        Label label7 = new Label((Composite)group2, 0);
        label7.setText("Initial Heap Size:");
        label7.setLayoutData((Object)new GridData(1));
        this.heapInitSize = new Text((Composite)group2, 2052);
        this.heapInitSize.setLayoutData((Object)gridData4);
        this.heapInitSize.setText(this.enclaveConfig.heapInitSize);
        this.heapInitSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.heapInitSize = EnclaveConfigDialog.this.heapInitSize.getText();
                if (!EnclaveConfigDialog.this.heapInitSize.getText().matches("0x[0-9a-fA-F]{1,}000")) {
                    EnclaveConfigDialog.this.statusLabel.setText("Error: The Initial Heap Size value must be Page Aligned.");
                } else {
                    EnclaveConfigDialog.this.checkPageAlign(EnclaveConfigDialog.this.heapInitSize);
                }
            }
        });
        Label label8 = new Label((Composite)group2, 0);
        label8.setText("Maximum Heap Size:");
        label8.setLayoutData((Object)new GridData(1));
        this.heapMaxSize = new Text((Composite)group2, 2052);
        this.heapMaxSize.setLayoutData((Object)gridData4);
        this.heapMaxSize.setText(this.enclaveConfig.heapMaxSize);
        this.heapMaxSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.heapMaxSize = EnclaveConfigDialog.this.heapMaxSize.getText();
                if (!EnclaveConfigDialog.this.heapMaxSize.getText().matches("0x[0-9a-fA-F]{1,}000")) {
                    EnclaveConfigDialog.this.statusLabel.setText("Error: The Maximum Heap Size value must be Page Aligned.");
                } else {
                    EnclaveConfigDialog.this.checkPageAlign(EnclaveConfigDialog.this.heapMaxSize);
                }
            }
        });
        Label label9 = new Label((Composite)group2, 0);
        label9.setText("TCS Number:");
        label9.setLayoutData((Object)new GridData(1));
        this.tcsNum = new Text((Composite)group2, 2052);
        this.tcsNum.setLayoutData((Object)gridData4);
        this.tcsNum.setText(this.enclaveConfig.tcsNum);
        this.tcsNum.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.tcsNum = EnclaveConfigDialog.this.tcsNum.getText();
            }
        });
        Label label10 = new Label((Composite)group2, 0);
        label10.setText("Maximum TCS Number:");
        label10.setLayoutData((Object)new GridData(1));
        this.tcsMaxNum = new Text((Composite)group2, 2052);
        this.tcsMaxNum.setLayoutData((Object)gridData4);
        this.tcsMaxNum.setText(this.enclaveConfig.tcsMaxNum);
        this.tcsMaxNum.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.tcsMaxNum = EnclaveConfigDialog.this.tcsMaxNum.getText();
            }
        });
        Label label11 = new Label((Composite)group2, 0);
        label11.setText("TCS Pool:");
        label11.setLayoutData((Object)new GridData(1));
        this.tcsPool = new Text((Composite)group2, 2052);
        this.tcsPool.setLayoutData((Object)gridData4);
        this.tcsPool.setText(this.enclaveConfig.tcsPool);
        this.tcsPool.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.tcsPool = EnclaveConfigDialog.this.tcsPool.getText();
            }
        });
        Label label12 = new Label((Composite)group2, 0);
        label12.setText("TCS Policy:");
        label12.setLayoutData((Object)new GridData(1));
        String[] stringArray = new String[]{"Unbound", "Bound"};
        this.tcsPolicy = new Combo((Composite)group2, 2060);
        this.tcsPolicy.setItems(stringArray);
        String string = stringArray[Integer.parseInt(this.enclaveConfig.tcsPolicy)];
        int n = this.tcsPolicy.indexOf(string);
        this.tcsPolicy.select(n < 0 ? 0 : n);
        this.tcsPolicy.setLayoutData((Object)gridData4);
        this.tcsPolicy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.tcsPolicy = EnclaveConfigDialog.this.tcsPolicy.getSelectionIndex() == 0 ? "0" : "1";
            }
        });
        Label label13 = new Label((Composite)group2, 0);
        label13.setText("Disable Debug:");
        label13.setLayoutData((Object)new GridData(1));
        this.disableDebug = new Button((Composite)group2, 32);
        GridData gridData5 = new GridData(768);
        this.disableDebug.setLayoutData((Object)gridData5);
        this.disableDebug.setSelection(this.enclaveConfig.disableDebug.equals("1"));
        this.disableDebug.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EnclaveConfigDialog.this.statusLabel.setText("");
                ((EnclaveConfigDialog)EnclaveConfigDialog.this).enclaveConfig.disableDebug = EnclaveConfigDialog.this.disableDebug.getSelection() ? "1" : "0";
            }
        });
        if (this.statusLabel.getText() != null) {
            this.statusLabel.setVisible(true);
        } else {
            this.statusLabel.setVisible(false);
        }
        return composite2;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Enclave Configuration Settings:");
    }

    protected Point getInitialSize() {
        return new Point(450, 570);
    }

    protected void okPressed() {
        this.enclaveConfig.prodId = this.prodID.getText();
        this.enclaveConfig.isvSvn = this.isvSvn.getText();
        this.enclaveConfig.stackMinSize = this.stackMinSize.getText();
        this.enclaveConfig.stackMaxSize = this.stackMaxSize.getText();
        this.enclaveConfig.heapMinSize = this.heapMinSize.getText();
        this.enclaveConfig.heapInitSize = this.heapInitSize.getText();
        this.enclaveConfig.heapMaxSize = this.heapMaxSize.getText();
        this.enclaveConfig.tcsNum = this.tcsNum.getText();
        this.enclaveConfig.tcsMaxNum = this.tcsMaxNum.getText();
        this.enclaveConfig.tcsPool = this.tcsPool.getText();
        this.enclaveConfig.tcsPolicy = this.tcsPolicy.getSelectionIndex() == 0 ? "0" : "1";
        String string = this.enclaveConfig.disableDebug = this.disableDebug.getSelection() ? "1" : "0";
        if (this.statusLabel.getText() == "" && this.enclaveConfig.stackMinSize.matches("0x[0-9a-fA-F]{1,}000") && this.enclaveConfig.stackMaxSize.matches("0x[0-9a-fA-F]{1,}000") && this.enclaveConfig.heapMinSize.matches("0x[0-9a-fA-F]{1,}000") && this.enclaveConfig.heapInitSize.matches("0x[0-9a-fA-F]{1,}000") && this.enclaveConfig.heapMaxSize.matches("0x[0-9a-fA-F]{1,}000")) {
            super.okPressed();
        }
    }

    private void checkPageAlign(Text text) {
        if (text != this.stackMinSize && !this.enclaveConfig.stackMinSize.matches("0x[0-9a-fA-F]{1,}000")) {
            this.statusLabel.setText("Error: The Minimum Stack Size value must be Page Aligned.");
        } else if (text != this.stackMaxSize && !this.enclaveConfig.stackMaxSize.matches("0x[0-9a-fA-F]{1,}000")) {
            this.statusLabel.setText("Error: The Maximum Stack Size value must be Page Aligned.");
        } else if (text != this.heapMinSize && !this.enclaveConfig.heapMinSize.matches("0x[0-9a-fA-F]{1,}000")) {
            this.statusLabel.setText("Error: The Minimum Heap Size value must be Page Aligned.");
        } else if (text != this.heapInitSize && !this.enclaveConfig.heapInitSize.matches("0x[0-9a-fA-F]{1,}000")) {
            this.statusLabel.setText("Error: The Initial Heap Size value must be Page Aligned.");
        } else if (text != this.heapMaxSize && !this.enclaveConfig.heapMaxSize.matches("0x[0-9a-fA-F]{1,}000")) {
            this.statusLabel.setText("Error: The Maximum Heap Size value must be Page Aligned.");
        } else {
            this.statusLabel.setText("");
        }
    }
}

