/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.dialogs;

import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public abstract class SGXDialogBase
extends Dialog {
    protected Shell shell;
    public Text configFileField;
    protected SelectionListener configFileSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            FilteredResourcesSelectionDialog filteredResourcesSelectionDialog = SGXDialogBase.dialogForConfig(SGXDialogBase.this.shell);
            filteredResourcesSelectionDialog.setTitle("Select Config File");
            if (filteredResourcesSelectionDialog.open() == 0) {
                IFile iFile = (IFile)filteredResourcesSelectionDialog.getResult()[0];
                SGXDialogBase.this.configFileField.setText(iFile.getLocation().toOSString());
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    public static FilteredResourcesSelectionDialog dialogForConfig(Shell shell) {
        IProject iProject = SGXDialogBase.getCurrentProject();
        FilteredResourcesSelectionDialog filteredResourcesSelectionDialog = new FilteredResourcesSelectionDialog(shell, false, (IContainer)iProject, 1, (IContainer)iProject){
            private final /* synthetic */ IContainer val$container;
            {
                this.val$container = iContainer2;
                super(shell, bl, iContainer, n);
                this.setInitialPattern("**");
            }

            protected IStatus validateItem(Object object) {
                IFile iFile = (IFile)object;
                if (iFile.getParent() instanceof IProject) {
                    return new Status(4, "com.intel.sgx", "The selected resource has to be part of the source folder");
                }
                return super.validateItem(object);
            }

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredResourcesSelectionDialog.ResourceFilter(this, this.val$container, true, 1){

                    public boolean matchItem(Object object) {
                        return this.isConfigFile(object);
                    }

                    private boolean isConfigFile(Object object) {
                        if (!object.toString().endsWith(".xml") || !super.matchItem(object)) {
                            return false;
                        }
                        try {
                            IFile iFile = (IFile)object;
                            return this.streamContainsString(iFile.getContents(), "<EnclaveConfiguration>");
                        }
                        catch (Throwable throwable) {
                            return false;
                        }
                    }
                };
            }

            public boolean streamContainsString(InputStream inputStream, String string) {
                Scanner scanner = new Scanner(inputStream);
                return scanner.findWithinHorizon(string, 0) != null;
            }
        };
        return filteredResourcesSelectionDialog;
    }

    public SGXDialogBase(Shell shell) {
        super(shell);
    }

    public SGXDialogBase(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    protected Text addGroup(Composite composite, String string, String string2, String string3, String string4, SelectionListener selectionListener) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setText(string);
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        label.setText(string2);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(string3);
        label2.setLayoutData((Object)new GridData(1));
        Text text = new Text((Composite)group, 2052);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 1;
        gridData2.widthHint = 400;
        text.setLayoutData((Object)gridData2);
        Button button = new Button((Composite)group, 8);
        button.setText(string4);
        GridData gridData3 = new GridData(3);
        gridData3.horizontalAlignment = 131072;
        gridData3.horizontalSpan = 1;
        gridData3.minimumWidth = 120;
        button.setLayoutData((Object)gridData3);
        button.addSelectionListener(selectionListener);
        return text;
    }

    public IPath getCurrentProjectPath() {
        IProject iProject = SGXDialogBase.getCurrentProject();
        IPath iPath = null;
        if (iProject != null) {
            iPath = iProject.getLocation();
        }
        return iPath;
    }

    public static IProject getCurrentProject() {
        IStructuredSelection iStructuredSelection;
        Object object;
        IProject iProject = null;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (object = (iStructuredSelection = (IStructuredSelection)iWorkbenchWindow.getSelectionService().getSelection()).getFirstElement()) instanceof IAdaptable) {
            iProject = (IProject)((IAdaptable)object).getAdapter(IProject.class);
        }
        return iProject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void addLabel(Group group, String string) {
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        label.setText(string);
    }
}

