/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.dialogs;

import com.intel.sgx.dialogs.SGXDialogBase;
import com.intel.sgx.handlers.UpdateSigningKey;
import java.io.File;
import javax.swing.JOptionPane;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdateSignKeyDialog
extends SGXDialogBase {
    private Shell shell;
    public Text sourceKeyFileField;
    public Text destinationKeyFileField;
    public static boolean regenerate = false;
    private final SelectionListener destinationKeyFileSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = UpdateSignKeyDialog.this.destinationKeyFileField.getText();
            FileDialog fileDialog = new FileDialog(UpdateSignKeyDialog.this.shell, 4096);
            fileDialog.setFilterPath(UpdateSignKeyDialog.this.getCurrentProjectPath().toOSString());
            fileDialog.setFilterExtensions(new String[]{"*.pem", "*"});
            string = fileDialog.open();
            UpdateSignKeyDialog.this.destinationKeyFileField.setText(string);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    private final SelectionListener sourceKeyFileSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = UpdateSignKeyDialog.this.sourceKeyFileField.getText();
            FileDialog fileDialog = new FileDialog(UpdateSignKeyDialog.this.shell, 4096);
            fileDialog.setFilterExtensions(new String[]{"*.pem", "*"});
            fileDialog.setFilterPath(UpdateSignKeyDialog.this.getCurrentProjectPath().toOSString());
            string = fileDialog.open();
            UpdateSignKeyDialog.this.sourceKeyFileField.setText(string);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };
    private final UpdateSigningKey handler;

    public UpdateSignKeyDialog(Shell shell, UpdateSigningKey updateSigningKey) {
        super(shell);
        this.shell = shell;
        this.handler = updateSigningKey;
        this.setShellStyle(48);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout(1, false);
        composite2.setLayout((Layout)gridLayout);
        this.destinationKeyFileField = this.addGroup(composite2, "Enclave Signing Key:", "Select the Signing Key to be Updated or Generated.", "Enclave Signing Key:", "Select", this.destinationKeyFileSelectionListener);
        this.sourceKeyFileField = this.addGroup(composite2, "Import:", "To import your own Signing Key use the Import Signing Key option.", "Import Signing Key:", "Import Key", this.sourceKeyFileSelectionListener);
        this.addGroup2(composite2);
        return composite2;
    }

    protected void addGroup2(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        group.setText("Generate:");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        label.setText("To Generate a new Signing Key use the Generate Signing Key option.");
        Label label2 = new Label((Composite)group, 68);
        label2.setText("Generate a new Signing Key:");
        label2.setLayoutData((Object)new GridData(768));
        Label label3 = new Label((Composite)group, 0);
        label3.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)group, 8);
        button.setText("Generate Key");
        GridData gridData2 = new GridData(3);
        gridData2.horizontalAlignment = 131072;
        gridData2.horizontalSpan = 1;
        gridData2.minimumWidth = 120;
        button.setLayoutData((Object)gridData2);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!UpdateSignKeyDialog.this.destinationKeyFileField.getText().isEmpty()) {
                    regenerate = true;
                    UpdateSignKeyDialog.this.setReturnCode(0);
                    UpdateSignKeyDialog.this.okPressed();
                    UpdateSignKeyDialog.this.close();
                } else {
                    JOptionPane.showMessageDialog(null, "Enclave Signing Key field is not provided.", "Error", 0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Import or (Re)Generate Enclave Signing Key");
    }

    protected void okPressed() {
        this.handler.sourceKeyFile = this.sourceKeyFileField.getText();
        this.handler.destinationKeyFile = this.destinationKeyFileField.getText();
        if (!this.sourceKeyFileField.getText().isEmpty() && !this.destinationKeyFileField.getText().isEmpty() && new File(this.sourceKeyFileField.getText()).isFile() || regenerate) {
            System.out.println("regenerate = " + regenerate);
            super.okPressed();
        } else if (this.sourceKeyFileField.getText().isEmpty() && this.destinationKeyFileField.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Enclave Signing Key and Import Singing Key are not provided.", "Error", 0);
        } else {
            if (this.sourceKeyFileField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(null, "Import Singing Key is not provided.", "Error", 0);
            } else if (!new File(this.sourceKeyFileField.getText()).isFile()) {
                JOptionPane.showMessageDialog(null, "Invalid Import Singing Key.", "Error", 0);
            }
            if (this.destinationKeyFileField.getText().isEmpty()) {
                JOptionPane.showMessageDialog(null, "Enclave Signing Key is not provided.", "Error", 0);
            }
        }
    }
}

