/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.discovery;

import com.intel.sgx.Activator;
import com.intel.sgx.discovery.SGXSDKDiscoveryUpdater;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class SGXSDKDiscoveredPathInfo
implements IDiscoveredPathManager.IDiscoveredPathInfo {
    private final IProject mProject;
    private long mLastUpdate = -1L;
    private IPath[] mIncludePaths;
    private Map<String, String> mSymbols;
    private boolean mNeedReindexing = false;
    private static final IPath LINUX_MK = new Path("sgx/Makefile");

    public SGXSDKDiscoveredPathInfo(IProject iProject) {
        this.mProject = iProject;
        this.load();
    }

    public IProject getProject() {
        return this.mProject;
    }

    public IPath[] getIncludePaths() {
        if (this.mNeedReindexing) {
            CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.mProject));
            this.mNeedReindexing = false;
        }
        return this.mIncludePaths;
    }

    void setIncludePaths(List<String> list) {
        this.mIncludePaths = new IPath[list.size()];
        int n = 0;
        for (String string : list) {
            this.mIncludePaths[n++] = new Path(string);
        }
        this.mNeedReindexing = true;
    }

    public Map<String, String> getSymbols() {
        if (this.mSymbols == null) {
            this.mSymbols = new HashMap<String, String>();
        }
        return this.mSymbols;
    }

    void setSymbols(Map<String, String> map) {
        this.mSymbols = map;
    }

    public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
        return null;
    }

    public void update(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.needUpdating()) {
            return;
        }
        new SGXSDKDiscoveryUpdater(this).runUpdate(iProgressMonitor);
        if (this.mIncludePaths != null && this.mSymbols != null) {
            this.recordUpdate();
            this.save();
        }
    }

    private boolean needUpdating() {
        if (this.mLastUpdate == -1L) {
            return true;
        }
        return this.mProject.getFile(LINUX_MK).getLocalTimeStamp() > this.mLastUpdate;
    }

    private void recordUpdate() {
        this.mLastUpdate = this.mProject.getFile(LINUX_MK).getLocalTimeStamp();
    }

    public void delete() {
        this.mLastUpdate = -1L;
    }

    private File getInfoFile() {
        File file = Activator.getDefault().getStateLocation().toFile();
        return new File(file, String.valueOf(this.mProject.getName()) + ".pathInfo");
    }

    private void save() {
        try {
            File file = this.getInfoFile();
            file.getParentFile().mkdirs();
            PrintStream printStream = new PrintStream(file);
            printStream.print("t,");
            printStream.print(this.mLastUpdate);
            printStream.println();
            IPath[] iPathArray = this.mIncludePaths;
            int n = this.mIncludePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath object = iPathArray[n2];
                printStream.print("i,");
                printStream.print(object.toPortableString());
                printStream.println();
                ++n2;
            }
            for (Map.Entry<String, String> entry : this.mSymbols.entrySet()) {
                printStream.print("d,");
                printStream.print(entry.getKey());
                printStream.print(",");
                printStream.print(entry.getValue());
                printStream.println();
            }
            printStream.close();
        }
        catch (IOException iOException) {
            Activator.log(iOException);
        }
    }

    private void load() {
        try {
            File file = this.getInfoFile();
            if (!file.exists()) {
                return;
            }
            long l = -1L;
            ArrayList<IPath> arrayList = new ArrayList<IPath>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                switch (string.charAt(0)) {
                    case 't': {
                        l = Long.valueOf(string.substring(2));
                        break;
                    }
                    case 'i': {
                        arrayList.add(Path.fromPortableString((String)string.substring(2)));
                        break;
                    }
                    case 'd': {
                        int n = string.indexOf(44, 2);
                        if (n == -1) {
                            hashMap.put(string.substring(2), "");
                            break;
                        }
                        hashMap.put(string.substring(2, n), string.substring(n + 1));
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.mLastUpdate = l;
            this.mIncludePaths = arrayList.toArray(new IPath[arrayList.size()]);
            this.mSymbols = hashMap;
        }
        catch (IOException iOException) {
            Activator.log(iOException);
        }
    }
}

