/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.discovery;

import com.intel.sgx.Activator;
import com.intel.sgx.build.SGXSDKCommandLauncher;
import com.intel.sgx.discovery.SGXSDKDiscoveredPathInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class SGXSDKDiscoveryUpdater {
    private final SGXSDKDiscoveredPathInfo mPathInfo;
    private final IProject mProject;
    private boolean mCPlusPlus = false;
    private String mCommand;
    private List<String> mArguments = new ArrayList<String>();

    public SGXSDKDiscoveryUpdater(SGXSDKDiscoveredPathInfo sGXSDKDiscoveredPathInfo) {
        this.mPathInfo = sGXSDKDiscoveredPathInfo;
        this.mProject = sGXSDKDiscoveredPathInfo.getProject();
    }

    public void runUpdate(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            Path path = new Path("make");
            String[] stringArray = new String[]{"-f", "sgx/Makefile", "-n", "-B"};
            String[] stringArray2 = this.calcEnvironment();
            File file = new File(this.mProject.getLocationURI());
            Path path2 = new Path(file.getAbsolutePath());
            Process process = new SGXSDKCommandLauncher().execute((IPath)path, stringArray, stringArray2, (IPath)path2, iProgressMonitor);
            if (process == null) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            while (string != null) {
                this.checkBuildLine(string);
                string = bufferedReader.readLine();
            }
            if (this.mCommand == null) {
                return;
            }
            this.mArguments.add("-E");
            this.mArguments.add("-P");
            this.mArguments.add("-v");
            this.mArguments.add("-dD");
            URL uRL = Activator.findFile(new Path("discovery/" + (this.mCPlusPlus ? "test.cpp" : "test.c")));
            File file2 = new File(FileLocator.toFileURL((URL)uRL).toURI());
            String string2 = file2.getAbsolutePath().replace('\\', '/');
            this.mArguments.add(string2);
            stringArray = this.mArguments.toArray(new String[this.mArguments.size()]);
            process = new SGXSDKCommandLauncher().execute((IPath)new Path(this.mCommand), stringArray, stringArray2, (IPath)path2, iProgressMonitor);
            final InputStream inputStream = process.getErrorStream();
            new Thread(){

                @Override
                public void run() {
                    SGXSDKDiscoveryUpdater.this.checkIncludes(inputStream);
                }
            }.start();
            this.checkDefines(process.getInputStream());
        }
        catch (IOException iOException) {
            throw new CoreException(Activator.newStatus(iOException));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CoreException(Activator.newStatus(uRISyntaxException));
        }
    }

    private String[] calcEnvironment() throws CoreException {
        Object object;
        Map map;
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)this.mProject);
        IBuilder iBuilder = iManagedBuildInfo.getDefaultConfiguration().getBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (iBuilder.appendEnvironment()) {
            IEnvironmentVariable[] object2;
            map = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)iBuilder.getParent().getParent());
            object = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = object2 = object.getVariables((ICConfigurationDescription)map, true);
            int n = object2.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable iEnvironmentVariable = iEnvironmentVariableArray[n2];
                hashMap.put(iEnvironmentVariable.getName(), iEnvironmentVariable.getValue());
                ++n2;
            }
        }
        if ((map = iBuilder.getExpandedEnvironment()) != null) {
            hashMap.putAll(map);
        }
        object = new ArrayList(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            StringBuffer stringBuffer = new StringBuffer((String)entry.getKey());
            stringBuffer.append('=').append((String)entry.getValue());
            object.add(stringBuffer.toString());
        }
        return object.toArray(new String[object.size()]);
    }

    private void checkBuildLine(String string) {
        Line line = new Line(string);
        String string2 = line.getToken();
        if (string2 == null) {
            return;
        }
        if (string2.endsWith("g++")) {
            if (this.mCommand == null || !this.mCPlusPlus) {
                this.mCommand = string2;
                this.mCPlusPlus = true;
            }
            this.gatherOptions(line);
        } else if (string2.endsWith("gcc")) {
            if (this.mCommand == null) {
                this.mCommand = string2;
            }
            this.gatherOptions(line);
        }
    }

    private void gatherOptions(Line line) {
        String string = line.getToken();
        while (string != null) {
            if (string.startsWith("-")) {
                String string2;
                if (string.equals("-I")) {
                    string2 = line.getToken();
                    if (string2 != null) {
                        this.addArg(String.valueOf(string) + string2);
                    }
                } else if (string.startsWith("-I")) {
                    this.addArg(string);
                } else if (string.equals("-D")) {
                    string2 = line.getToken();
                    if (string2 != null) {
                        this.addArg(String.valueOf(string) + string2);
                    }
                } else if (string.startsWith("-D")) {
                    this.addArg(string);
                } else if (string.startsWith("-f")) {
                    this.addArg(string);
                } else if (string.startsWith("-m")) {
                    this.addArg(string);
                } else if (string.startsWith("--sysroot")) {
                    this.addArg(string);
                }
            }
            string = line.getToken();
        }
    }

    private void addArg(String string) {
        if (!this.mArguments.contains(string)) {
            this.mArguments.add(string);
        }
    }

    private void checkIncludes(InputStream inputStream) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            boolean bl2 = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!bl) {
                    if (string.equals("#include \"...\" search starts here:")) {
                        bl = true;
                    }
                } else if (!bl2) {
                    if (string.equals("#include <...> search starts here:")) {
                        bl2 = true;
                    } else {
                        arrayList.add(string.trim());
                    }
                } else if (string.equals("End of search list.")) {
                    this.mPathInfo.setIncludePaths(arrayList);
                } else {
                    arrayList.add(string.trim());
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Activator.log(iOException);
        }
    }

    private void checkDefines(InputStream inputStream) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (string.startsWith("#define")) {
                    Line line = new Line(string, 7);
                    String string2 = line.getToken();
                    if (string2 == null) continue;
                    String string3 = line.getRemaining();
                    if (string3 == null) {
                        string3 = "";
                    }
                    hashMap.put(string2, string3);
                }
                string = bufferedReader.readLine();
            }
            this.mPathInfo.setSymbols(hashMap);
        }
        catch (IOException iOException) {
            Activator.log(iOException);
        }
    }

    private static class Line {
        private final String line;
        private int pos;

        public Line(String string) {
            this.line = string;
        }

        public Line(String string, int n) {
            this(string);
            this.pos = n;
        }

        public String getToken() {
            this.skipWhiteSpace();
            if (this.pos == this.line.length()) {
                return null;
            }
            int n = this.pos;
            boolean bl = false;
            do {
                char c;
                if ((c = this.line.charAt(this.pos)) == ' ') {
                    if (bl) continue;
                    return this.line.substring(n, this.pos);
                }
                if (c != '\"') continue;
                boolean bl2 = bl = !bl;
            } while (++this.pos != this.line.length());
            return null;
        }

        private String getRemaining() {
            if (this.pos == this.line.length()) {
                return null;
            }
            this.skipWhiteSpace();
            String string = this.line.substring(this.pos);
            this.pos = this.line.length();
            return string;
        }

        private void skipWhiteSpace() {
            while (true) {
                if (this.pos == this.line.length()) {
                    return;
                }
                char c = this.line.charAt(this.pos);
                if (c != ' ') break;
                ++this.pos;
            }
        }
    }
}

