/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.handlers;

import com.intel.sgx.Activator;
import com.intel.sgx.dialogs.AddUntrustedModuleDialog;
import com.intel.sgx.handlers.ModuleCreationBaseHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddUntrustedModule
extends ModuleCreationBaseHandler
implements IHandler {
    public String edlFilename = "";
    public String libPath = "";
    private IPath edlCanonicalFilename;
    private IPath libCanonicalPathname;

    public void addHandlerListener(IHandlerListener iHandlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string;
        String string2;
        IFolder iFolder;
        IProject iProject = null;
        Shell shell = null;
        AddUntrustedModuleDialog addUntrustedModuleDialog = new AddUntrustedModuleDialog(shell, this);
        if (addUntrustedModuleDialog.open() != 0) {
            return null;
        }
        if (this.edlFilename.isEmpty() && this.libPath.isEmpty()) {
            System.err.println("No Enclave selected to Import.");
            return null;
        }
        if (this.edlFilename.isEmpty()) {
            System.err.println("Edl File not selected.");
            return null;
        }
        this.edlCanonicalFilename = Path.fromOSString((String)this.edlFilename);
        if (!this.edlCanonicalFilename.getFileExtension().toLowerCase().equals("edl")) {
            System.err.println("Error: EDL file extension = " + this.edlCanonicalFilename.getFileExtension());
            return null;
        }
        String string3 = this.edlCanonicalFilename.removeFileExtension().lastSegment();
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        Object object = null;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IResource) {
            iProject = ((IResource)object).getProject();
        }
        if (!iProject.exists()) {
            System.err.println("Error:  Project not found");
            return null;
        }
        IPath iPath = iProject.getProjectRelativePath().append("sgx").append("untrusted_" + string3);
        try {
            int n = 1;
            while (n <= iPath.segmentCount()) {
                iFolder = iProject.getFolder(iPath.uptoSegment(n));
                if (!iFolder.exists()) {
                    iFolder.create(true, true, null);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            System.err.println("Error:  Error creating enclave directory.");
            Activator.log((Exception)((Object)coreException));
            coreException.printStackTrace();
        }
        IPath iPath2 = Path.fromOSString((String)this.edlFilename).makeRelativeTo(iProject.getLocation().append("sgx"));
        String string4 = iPath2.toOSString();
        iFolder = Path.fromOSString((String)this.libPath).makeRelativeTo(iProject.getLocation().append("sgx"));
        if (iFolder.removeLastSegments(1).lastSegment().toString().equalsIgnoreCase("sgx")) {
            string2 = iFolder.removeLastSegments(3).toOSString();
            string = iFolder.removeFirstSegments(iFolder.segmentCount() - 3).removeLastSegments(1).toOSString();
        } else if (iFolder.removeLastSegments(1).lastSegment().toString().equalsIgnoreCase("src")) {
            string2 = iFolder.removeLastSegments(3).toOSString();
            string = iFolder.removeFirstSegments(iFolder.segmentCount() - 3).removeLastSegments(1).toOSString();
        } else {
            string2 = iFolder.removeLastSegments(2).toOSString();
            string = iFolder.removeFirstSegments(iFolder.segmentCount() - 2).removeLastSegments(1).toOSString();
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        TemplateCore templateCore = null;
        templateCore = this.isCPProject(iProject) ? TemplateEngine.getDefault().getTemplateById("SGXUntrustedModuleC++Minimal") : TemplateEngine.getDefault().getTemplateById("SGXUntrustedModuleCMinimal");
        Map map = templateCore.getValueStore();
        map.put("projectName", iProject.getName());
        map.put("sourcepath", string2);
        map.put("edlPath", string4);
        map.put("baseName", string3);
        map.put("workspacePath", string2);
        map.put("modPath", string);
        map.put("ENCLAVENAME", string3.toUpperCase());
        map.put("libPath", this.libPath);
        map.put("SdkPathFromPlugin", Activator.getDefault().getPreferenceStore().getString("SDKPathPreference"));
        templateCore.executeTemplateProcesses((IProgressMonitor)nullProgressMonitor, false);
        try {
            AddUntrustedModule.copyFile(new File(this.edlFilename), iProject.getLocation().append("sgx").append("untrusted_" + string3).append(String.valueOf(string3) + ".edl").toFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        try {
            iProject.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            Activator.log((Exception)((Object)coreException));
            coreException.printStackTrace();
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener iHandlerListener) {
    }

    public void setFilename(String string) {
        this.edlFilename = string;
    }

    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[4092];
        if (file != null && file2 != null && file.isFile()) {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    int n;
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (Exception exception) {
                    Activator.log(exception);
                    System.err.println("Error: " + exception.toString());
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    finally {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }
        }
    }
}

