/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.handlers;

import com.intel.sgx.Activator;
import com.intel.sgx.dialogs.EnclaveConfigDialog;
import com.intel.sgx.dialogs.SGXDialogBase;
import com.intel.sgx.handlers.SGXHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnclaveConfigHandler
extends SGXHandler {
    public String prodId;
    public String isvSvn;
    public String stackMinSize;
    public String stackMaxSize;
    public String heapMinSize;
    public String heapInitSize;
    public String heapMaxSize;
    public String tcsNum;
    public String tcsMaxNum;
    public String tcsPool;
    public String tcsPolicy;
    public String disableDebug;
    private IFile configPath;

    @Override
    public void addHandlerListener(IHandlerListener iHandlerListener) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object executeSGXStuff() throws SGXHandler.CancelException, SGXHandler.ErrorException {
        FilteredResourcesSelectionDialog filteredResourcesSelectionDialog = SGXDialogBase.dialogForConfig(this.shell);
        filteredResourcesSelectionDialog.setTitle("Select Config File");
        if (filteredResourcesSelectionDialog.open() != 0) {
            EnclaveConfigHandler.cancel();
        }
        this.configPath = (IFile)filteredResourcesSelectionDialog.getResult()[0];
        this.readConfig(this.configPath.getLocation());
        EnclaveConfigDialog enclaveConfigDialog = new EnclaveConfigDialog(this.shell, this);
        if (enclaveConfigDialog.open() != 0) {
            return null;
        }
        this.writeConfig();
        this.refreshProject();
        return null;
    }

    protected void writeConfig() {
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        TemplateCore templateCore = TemplateEngine.getDefault().getTemplateById("SGXEnclaveConfig");
        Map map = templateCore.getValueStore();
        map.put("projectName", this.project.getName());
        map.put("configFile", this.configPath.getProjectRelativePath().toOSString());
        map.put("ProdID", this.prodId);
        map.put("IsvSvn", this.isvSvn);
        map.put("StackMinSize", this.stackMinSize);
        map.put("StackMaxSize", this.stackMaxSize);
        map.put("HeapMinSize", this.heapMinSize);
        map.put("HeapInitSize", this.heapInitSize);
        map.put("HeapMaxSize", this.heapMaxSize);
        map.put("TcsNum", this.tcsNum);
        map.put("TcsMaxNum", this.tcsMaxNum);
        map.put("TcsMinPool", this.tcsPool);
        map.put("TcsPolicy", this.tcsPolicy);
        map.put("DisableDebug", this.disableDebug);
        IStatus[] iStatusArray = templateCore.executeTemplateProcesses((IProgressMonitor)nullProgressMonitor, true);
    }

    protected void readConfig(IPath iPath) throws SGXHandler.ErrorException {
        try {
            String string = iPath.toString();
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("EnclaveConfiguration");
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.prodId = element.getElementsByTagName("ProdID").item(0).getTextContent();
                this.isvSvn = element.getElementsByTagName("ISVSVN").item(0).getTextContent();
                this.stackMinSize = element.getElementsByTagName("StackMinSize").item(0).getTextContent();
                this.stackMaxSize = element.getElementsByTagName("StackMaxSize").item(0).getTextContent();
                this.heapMinSize = element.getElementsByTagName("HeapMinSize").item(0).getTextContent();
                this.heapInitSize = element.getElementsByTagName("HeapInitSize").item(0).getTextContent();
                this.heapMaxSize = element.getElementsByTagName("HeapMaxSize").item(0).getTextContent();
                this.tcsNum = element.getElementsByTagName("TCSNum").item(0).getTextContent();
                this.tcsMaxNum = element.getElementsByTagName("TCSMaxNum").item(0).getTextContent();
                this.tcsPool = element.getElementsByTagName("TCSMinPool").item(0).getTextContent();
                this.tcsPolicy = element.getElementsByTagName("TCSPolicy").item(0).getTextContent();
                this.disableDebug = element.getElementsByTagName("DisableDebug").item(0).getTextContent();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Activator.log(parserConfigurationException);
            parserConfigurationException.printStackTrace();
            EnclaveConfigHandler.quitWithError("Could not parse '" + iPath.toOSString() + "'");
        }
        catch (SAXException sAXException) {
            Activator.log(sAXException);
            sAXException.printStackTrace();
            EnclaveConfigHandler.quitWithError("Could not parse '" + iPath.toOSString() + "'");
        }
        catch (IOException iOException) {
            Activator.log(iOException);
            iOException.printStackTrace();
            EnclaveConfigHandler.quitWithError("Could not read'" + iPath.toOSString() + "'");
        }
    }
}

