/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class SGXHandler
implements IHandler {
    public String projectPath = null;
    protected IProject project;
    protected Shell shell;

    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        try {
            this.initializeShell();
            this.initializeProject(executionEvent);
            return this.executeSGXStuff();
        }
        catch (ErrorException errorException) {
            errorException.printStackTrace();
        }
        catch (CancelException cancelException) {}
        return null;
    }

    protected abstract Object executeSGXStuff() throws ErrorException, CancelException;

    public static void copyFile(File file, File file2) throws ErrorException {
        block44: {
            byte[] byArray = new byte[4092];
            if (file != null && file2 != null && file.isFile()) {
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        int n;
                        fileInputStream = new FileInputStream(file);
                        fileOutputStream = new FileOutputStream(file2);
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println("Error: " + iOException.toString());
                        SGXHandler.quitWithError("Could not copy from\n'" + file.getAbsolutePath() + "'\n" + "to\n" + "'" + file2.getAbsolutePath());
                        try {
                            try {
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            catch (IOException iOException2) {
                                iOException2.printStackTrace();
                                if (fileOutputStream == null) break block44;
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException3) {
                                    iOException3.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException4) {
                                    iOException4.printStackTrace();
                                }
                            }
                        }
                    }
                }
                finally {
                    block46: {
                        try {
                            try {
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                if (fileOutputStream != null) {
                                    try {
                                        fileOutputStream.close();
                                    }
                                    catch (IOException iOException5) {
                                        iOException5.printStackTrace();
                                    }
                                }
                                break block46;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    protected static void quitWithError(String string) throws ErrorException {
        JOptionPane.showMessageDialog(null, string, "Two Step Enclave Sign", 0);
        throw new ErrorException(string);
    }

    protected static void cancel() throws CancelException {
        throw new CancelException();
    }

    protected void initializeProject(ExecutionEvent executionEvent) throws ErrorException {
        this.project = null;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        Object object = null;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IResource) {
            this.project = ((IResource)object).getProject();
        }
        if (!this.project.exists()) {
            SGXHandler.quitWithError("Project not found");
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener iHandlerListener) {
    }

    public void addHandlerListener(IHandlerListener iHandlerListener) {
    }

    public void dispose() {
    }

    protected void initializeShell() {
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected void refreshProject() throws ErrorException {
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            SGXHandler.quitWithError(coreException.getLocalizedMessage());
        }
    }

    protected void info(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 1);
    }

    protected static class CancelException
    extends Exception {
    }

    protected static class ErrorException
    extends Exception {
        public ErrorException(String string) {
            super(string);
        }
    }
}

