/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.handlers;

import com.intel.sgx.handlers.SGXHandler;
import com.intel.sgx.preferences.PreferenceConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class TwoStepSignHandlerBase
extends SGXHandler {
    public String hashFile = null;
    public String configFile = null;
    public String enclaveFile = null;
    public String externalSignPublicKeyFile = null;
    public String externallySignedHashFile = null;
    public String outputSignedEnclaveFile = null;
    protected File signtool;

    protected void executeGenData() throws SGXHandler.ErrorException {
        this.validateConfigFile();
        this.validateEnclaveFile();
        this.refreshProject();
        this.executeSignTool("gendata", "-enclave", this.enclaveFile, "-config", this.configFile, "-out", this.hashFile);
        this.refreshProject();
        this.validateHashFile();
    }

    protected void executeCatSig() throws SGXHandler.ErrorException {
        this.validateEnclaveFile();
        this.validateConfigFile();
        this.validateHashFile();
        this.validateExternalSignPublicKeyFile();
        this.validateExternallySignedHashFile();
        this.executeSignTool("catsig", "-enclave", this.enclaveFile, "-config", this.configFile, "-unsigned", this.hashFile, "-key", this.externalSignPublicKeyFile, "-sig", this.externallySignedHashFile, "-out", this.outputSignedEnclaveFile);
        this.refreshProject();
        this.validateOutputSignedEnclaveFile();
        this.info("Two Step Enclave Sign", "Enclave signed successfully !");
    }

    void initializeSigntool() throws SGXHandler.ErrorException {
        this.signtool = PreferenceConstants.getSDKDescriptor().getSignerPath();
        if (!this.signtool.exists() || this.signtool.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Error generating hash! Sign Tool Not Found !\n Please make sure to have written in the box the value for  Intel(R) SGX SDK Directory in Window->Preferences->Intel(R) SGX Preferences. \n Usually the path is in /opt/intel/sgxsdk/");
        }
    }

    protected void validateEnclaveFile() throws SGXHandler.ErrorException {
        File file = new File(this.enclaveFile);
        if (!file.exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Error generating hash! Unsigned Enclave File Not Found! Try building the enclave first");
        }
    }

    protected void validateConfigFile() throws SGXHandler.ErrorException {
        File file;
        if (this.configFile == null || this.configFile.isEmpty()) {
            TwoStepSignHandlerBase.quitWithError("Error Enclave Configuration  File Not Found !");
        }
        if (!(file = new File(this.configFile)).exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Enclave Config File Not Found !");
        }
    }

    protected void validateExternallySignedHashFile() throws SGXHandler.ErrorException {
        File file;
        if (this.externallySignedHashFile == null || this.externallySignedHashFile.isEmpty()) {
            TwoStepSignHandlerBase.quitWithError("Error signing enclave! Signature File Not Found !");
        }
        if (!(file = new File(this.externallySignedHashFile)).exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Error signing enclave! Signature File Not Found !");
        }
    }

    protected void validateExternalSignPublicKeyFile() throws SGXHandler.ErrorException {
        File file;
        if (this.externalSignPublicKeyFile == null || this.externalSignPublicKeyFile.isEmpty()) {
            TwoStepSignHandlerBase.quitWithError("Public Key File Not Found !");
        }
        if (!(file = new File(this.externalSignPublicKeyFile)).exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Error signing enclave! Public Key File Not Found !");
        }
    }

    private void validateOutputSignedEnclaveFile() throws SGXHandler.ErrorException {
        File file;
        if (this.outputSignedEnclaveFile == null || this.outputSignedEnclaveFile.isEmpty()) {
            TwoStepSignHandlerBase.quitWithError("Output Signed File Not Found !");
        }
        if (!(file = new File(this.outputSignedEnclaveFile)).exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Output Signed File Not Found !");
        }
    }

    protected void validateHashFile() throws SGXHandler.ErrorException {
        File file;
        if (this.hashFile == null || this.hashFile.isEmpty()) {
            TwoStepSignHandlerBase.quitWithError("Hash File Not Found !");
        }
        if (!(file = new File(this.hashFile)).exists() || file.isDirectory()) {
            TwoStepSignHandlerBase.quitWithError("Hash File Not Found !");
        }
    }

    protected void executeSignTool(String ... stringArray) throws SGXHandler.ErrorException {
        try {
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = this.signtool.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            String string = "";
            Process process = Runtime.getRuntime().exec(stringArray2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (bufferedReader.readLine() != null) {
            }
            String[] stringArray3 = new String[20];
            int n = 0;
            while ((stringArray3[n] = bufferedReader2.readLine()) != null) {
                string = String.valueOf(string) + stringArray3[n] + "\n";
                ++n;
            }
            String string2 = stringArray3[n - 1];
            if (!string2.equals("Succeed.")) {
                TwoStepSignHandlerBase.quitWithError("Error generating hash! " + string);
            }
        }
        catch (IOException iOException) {
            TwoStepSignHandlerBase.quitWithError(iOException.getLocalizedMessage());
        }
    }
}

