/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.handlers;

import com.intel.sgx.Activator;
import com.intel.sgx.dialogs.UpdateSignKeyDialog;
import com.intel.sgx.handlers.SGXHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UpdateSigningKey
extends SGXHandler {
    public String sourceKeyFile = null;
    public String destinationKeyFile = null;
    public String projectPath = null;

    @Override
    protected Object executeSGXStuff() throws SGXHandler.ErrorException, SGXHandler.CancelException {
        UpdateSignKeyDialog updateSignKeyDialog = new UpdateSignKeyDialog(this.shell, this);
        int n = updateSignKeyDialog.open();
        if (n != 0) {
            UpdateSigningKey.cancel();
        }
        if (!UpdateSignKeyDialog.regenerate) {
            IPath iPath = Path.fromOSString((String)this.sourceKeyFile);
            IPath iPath2 = Path.fromOSString((String)this.destinationKeyFile);
            UpdateSigningKey.copyFile(iPath.toFile(), iPath2.toFile());
            this.refreshProject();
            this.info("Update Intel(R) SGX Enclave Signing Key", "copied \n'" + this.sourceKeyFile + "' into \n'" + iPath2 + "'");
        } else {
            UpdateSignKeyDialog.regenerate = false;
            try {
                String string = "openssl genrsa -out " + this.destinationKeyFile + " -3 3072";
                Process process = Runtime.getRuntime().exec(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while (bufferedReader.readLine() != null) {
                }
                while (bufferedReader2.readLine() != null) {
                }
                this.project.refreshLocal(2, null);
                if (process.exitValue() == 0) {
                    this.info("Update Intel(R) SGX Enclave Signing Key", "'" + this.destinationKeyFile + "'" + " was generated!");
                } else {
                    UpdateSigningKey.quitWithError("Could not generate '" + this.destinationKeyFile + "'!!!");
                }
            }
            catch (IOException iOException) {
                Activator.log(iOException);
                iOException.printStackTrace();
            }
            catch (CoreException coreException) {
                Activator.log((Exception)((Object)coreException));
                coreException.printStackTrace();
            }
        }
        return null;
    }
}

