/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.preferences;

import com.intel.sgx.Activator;
import com.intel.sgx.preferences.ISDKDescriptor;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceConstants {
    public static final String SDK_PATH = "SDKPathPreference";

    public static ISDKDescriptor getSDKDescriptor() {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        File file = new File(iPreferenceStore.getString(SDK_PATH));
        if (System.getProperty("os.arch").contains("64")) {
            return new SGXSDK64Descriptor(file);
        }
        return new SGXSDK32Descriptor(file);
    }

    public static class SGXSDK32Descriptor
    implements ISDKDescriptor {
        private final File sdkDir;
        private final File toolDir;
        private final File signerPath;
        private final File edger8rPath;

        public SGXSDK32Descriptor(File file) {
            this.sdkDir = file;
            this.toolDir = new File(file, "bin/x86");
            this.signerPath = new File(this.toolDir, "sgx_sign");
            this.edger8rPath = new File(this.toolDir, "sgx_edger8r");
        }

        @Override
        public File getSdkDir() {
            return this.sdkDir;
        }

        @Override
        public File getToolsDir() {
            return this.toolDir;
        }

        @Override
        public File getSignerPath() {
            return this.signerPath;
        }

        @Override
        public File getEdger8rPath() {
            return this.edger8rPath;
        }
    }

    public static class SGXSDK64Descriptor
    implements ISDKDescriptor {
        private final File sdkDir;
        private final File toolDir;
        private final File signerPath;
        private final File edger8rPath;

        public SGXSDK64Descriptor(File file) {
            this.sdkDir = file;
            this.toolDir = new File(file, "bin/x64");
            this.signerPath = new File(this.toolDir, "sgx_sign");
            this.edger8rPath = new File(this.toolDir, "sgx_edger8r");
        }

        @Override
        public File getSdkDir() {
            return this.sdkDir;
        }

        @Override
        public File getToolsDir() {
            return this.toolDir;
        }

        @Override
        public File getSignerPath() {
            return this.signerPath;
        }

        @Override
        public File getEdger8rPath() {
            return this.edger8rPath;
        }
    }
}

