/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.preferences;

import com.intel.sgx.Activator;
import com.intel.sgx.SdkPathVariableProvider;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SGXPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private SGXSdkDirectoryFieldEditor sgxSdkDirectoryEditor;

    public SGXPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Intel(R) SGX Preferences");
    }

    protected void createFieldEditors() {
        this.sgxSdkDirectoryEditor = new SGXSdkDirectoryFieldEditor("SDKPathPreference", "&Intel(R) SGX SDK Directory:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.sgxSdkDirectoryEditor);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.sgxSdkDirectoryEditor != null) {
            this.sgxSdkDirectoryEditor.dispose();
            this.sgxSdkDirectoryEditor = null;
        }
    }

    private static class SGXSdkDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public SGXSdkDirectoryFieldEditor(String string, String string2, Composite composite) {
            super(string, string2, composite);
            this.setEmptyStringAllowed(true);
        }

        protected boolean doCheckState() {
            if (!super.doCheckState()) {
                this.setErrorMessage("Intel(R) SGX Preferences: Not a Valid directory");
                return false;
            }
            String string = this.getTextControl().getText().trim();
            if (!string.isEmpty() && !SdkPathVariableProvider.isValidSGXSdkLocation(string)) {
                this.setErrorMessage("Intel(R) SGX SDK: Not a Valid SGX SDK directory");
                return false;
            }
            return true;
        }

        public Text getTextControl(Composite composite) {
            this.setValidateStrategy(0);
            return super.getTextControl(composite);
        }
    }
}

