/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sgx.testers;

import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.StructuredSelection;

public class SGXPropertyTester
extends PropertyTester {
    private static final Pattern isRelease = Pattern.compile(".*Release.*");
    private static final Pattern isHW = Pattern.compile(".*Hardware.*");
    private static final Pattern isPreRelease = Pattern.compile(".*Prerelease.*");

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        if (string.equals("twoStepsActive")) {
            IProject iProject = this.getProjectOfSelectedItem(object);
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            return this.isHW(iManagedBuildInfo) && this.isRelease(iManagedBuildInfo) && !this.isPreRelease(iManagedBuildInfo);
        }
        if (string.equals("sgxNatureAdded")) {
            this.getProjectOfSelectedItem(object);
            return true;
        }
        return false;
    }

    private IProject getProjectOfSelectedItem(Object object) {
        StructuredSelection structuredSelection = (StructuredSelection)object;
        IResource iResource = (IResource)structuredSelection.getFirstElement();
        IProject iProject = iResource.getProject();
        return iProject;
    }

    boolean isHW(IManagedBuildInfo iManagedBuildInfo) {
        return isHW.matcher(iManagedBuildInfo.getConfigurationName()).matches();
    }

    boolean isRelease(IManagedBuildInfo iManagedBuildInfo) {
        return isRelease.matcher(iManagedBuildInfo.getConfigurationName()).matches();
    }

    boolean isPreRelease(IManagedBuildInfo iManagedBuildInfo) {
        return isPreRelease.matcher(iManagedBuildInfo.getConfigurationName()).matches();
    }
}

